# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # First round: Cooperate
    
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower():
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower():
        return "C"  # Minimize losses against always-defect
    
    # Tit-for-Tat with Forgiveness (10% chance to forgive)
    if random.random() < 0.1:
        return "C"
    
    # Default to Tit-for-Tat
    return opp_history[-1]